/******************************************************************************
 CExecuteOptions.c

				CExecuteOptions Dialog Director Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	Generated by Classy (Object Factory) 2:55 PM Sat, Oct 2, 1993

	This file is only generated once. You can modify it by filling
	in the placeholder functions and adding any new functions you wish.

	If you change the name of the dialog class, a fresh version of this
	file will be generated. If you have made any changes to the file
	with the old name, you will have to copy those changes to the new
	file by hand.

 ******************************************************************************/

#include "CExecuteOptions.h"

#include "ExecuteOptionsItems.h"
//#include "AppCommands.h"			// Remove comments if DoCommand overridden
#include "AdaGlobals.h"
/**
#include <CIntegerText.h>
#include <CControl.h>
#include <CPopup.h>
#include <CPopupPane.h>
#include <CArrayPane.h>
#include <CIconButton.h>
#include <CPictureButton.h>
#include <CSwissArmyButton.h>

#include <Constants.h>
#include <CDecorator.h>
#include <CDesktop.h>
#include <CDirectorOwner.h>
#include <CFile.h>
#include <TBUtilities.h>
#include <CWindow.h>
**/


/**** C O N S T R U C T I O N / D E S T R U C T I O N   M E T H O D S ****/


/******************************************************************************
 ICExecuteOptions

	Initialize the dialog

	IMPORTANT NOTE: When an object is initialized as part of a
	'CVue' resource, this I-function is NEVER CALLED. Instead,
	the object is initialized in its GetFrom method(s). To add your
	own initialization, override GetFrom.

 ******************************************************************************/

void CExecuteOptions::ICExecuteOptions(CDirectorOwner *aSupervisor)

{
		// Initialize data members that must be set up before
		// BeginData is called here

	x_CExecuteOptions::Ix_CExecuteOptions(aSupervisor);

		// Initialize any other data members here

}


/******************************************************************************
 BeginData

	Set up initial pane values
******************************************************************************/

void CExecuteOptions::BeginData(CExecuteOptionsData *initial)

{
ExOptions options;

	 	//	Superclass calls BeginData once after the window is created
	 	//	to gather the initial values for the dialog panes. Note that
	 	//	BeginData is called *before* Ix_CExecuteOptions returns. If you
	 	//	do not override this function, all values are initially
	 	//	zero or null.

	gAdaApp->GetExOptions(&options);
	
	initial->fExecuteOptions_Source = options.exOptSource;
	initial->fExecuteOptions_Routines = options.exOptRoutines;
	initial->fExecuteOptions_Exception = options.exOptException;
	initial->fExecuteOptions_Rendezvous = options.exOptRendezvous;
	initial->fExecuteOptions_Task = options.exOptTask;
	if (options.exRoundRobin) {
		initial->fExecuteOptions_Robin = 1;
		initial->fExecuteOptions_Block = 0;
	}
	else {
		initial->fExecuteOptions_Robin = 0;
		initial->fExecuteOptions_Block = 1;
	}
	NumToString(options.exQuantumSize, initial->fExecuteOptions_Size);

}

/******************************************************************************
 EndData
 
 	Receive final values from the dialog
******************************************************************************/

void CExecuteOptions::EndData(CExecuteOptionsData *final)

{
ExOptions options;

		//	The values of all panes are returned by this function,
		//	which is called just before Close for a modeless dialog,
		//	or just before returning from DoModalDialog.
		
		//	If DoModalDialog returns cmdCancel, EndData is called
		//	with the values initially supplied to BeginData, allowing
		//	you to back out any intermediate changes made in response
		//	to UpdateData. If you do not use UpdateData, you can
		//	test the value of dismissCmd to see whether to respond
		//	to EndData.

	if (dismissCmd != cmdCancel) {

		gAdaApp->GetExOptions(&options);

		options.exOptSource = final->fExecuteOptions_Source;
		options.exOptRoutines = final->fExecuteOptions_Routines;
		options.exOptException = final->fExecuteOptions_Exception;
		options.exOptRendezvous = final->fExecuteOptions_Rendezvous;
		options.exOptTask = final->fExecuteOptions_Task;

		if (final->fExecuteOptions_Robin == 1) {
			long val;

			options.exRoundRobin = true;
			StringToNum(final->fExecuteOptions_Size, &val);
			options.exQuantumSize = val;
		}
		else {
			options.exRoundRobin = false;
		}

		gAdaApp->SetExOptions(options);
	}
}

